IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PROD_TRILHO_EXCESSO_RC_CLI') 
BEGIN

	CREATE TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_CTR] [int] NOT NULL,
		[CD_CLI] [int] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_TRILHO_EXCESSO_RC_CLI] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_CTR] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_RC_CLI_EST_PROD_TRILHO_EXCESSO] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_CTR])
	REFERENCES [dbo].[EST_PROD_TRILHO_EXCESSO] ([CD_EMP], [CD_FILIAL], [CD_CTR])

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI] CHECK CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_RC_CLI_EST_PROD_TRILHO_EXCESSO]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_RC_CLI_RC_CLI] FOREIGN KEY([CD_EMP], [CD_CLI])
	REFERENCES [dbo].[RC_CLI] ([CD_EMP], [CD_CLI])

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI] CHECK CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_RC_CLI_RC_CLI]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_RC_CLI_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_RC_CLI_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_RC_CLI_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_RC_CLI] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_RC_CLI_CD_CLI]  DEFAULT ((0)) FOR [CD_CLI]
END